import polars as pl

import matplotlib.pyplot as plt

df = pl.read_csv("Tire Data\B1965raw4.dat", separator="	", skip_rows=1, skip_rows_after_header=1)

df["SA"]

fig, axes = plt.subplots(nrows=2, ncols=2, figsize=(5, 3))

#select time:
df = df.filter((pl.col("ET")>1500) & (pl.col("ET")<1600))

print(df["FY"].max())
print(df["FZ"].min())
print(df["FX"].min())
#print(df)



axes[0,0].plot(df[["ET"]],df[["SA"]])
axes[0,0].set_title("SA")

axes[1,0].plot(df[["ET"]],df[["FY"]])
axes[1,0].set_title("FY")


axes[0,1].plot(df[["ET"]],df[["FY"]])
axes[0,1].set_title("FY")


axes[1,1].plot(df[["ET"]],df[["MZ"]])
axes[1,1].set_title("MZ")


#Want to check max lateral force for given speeds 

print(df.sort(["FY"],descending=True)["FY","FZ","FX","ET","SA","V"])
df=df.sort(["FY"],descending=True)["FY","FZ","FX","ET","SA","V"]
print(df.filter((pl.col("FZ") > -430) & (pl.col("FZ" ) <-400) & (pl.col("V") < 45))["FY","FZ","FX","ET","SA","V"])

fig.tight_layout()

plt.show()

df.filter((pl.col("FZ") < -725) & (pl.col("FZ") > -775))